<?php /* Template Name:   about   */ ?>
<?php get_header() ?>


<section class="head">  
    <div class="container">
        <div class="tit">
            <h2><?php the_title() ?></h2>
            <?php the_field('tit'); ?>
        </div>
    </div>
    <i></i>
</section>





<section class="about-page">
    <div class="container">

        <div class="block col-12 col-md-6">
            <?php if(have_posts()) : ?>
            <?php while(have_posts()) : the_post(); ?>
            <?php the_post_thumbnail(); ?> 
                <?php the_content() ?>
            <?php endwhile; ?>
            <?php else : ?>
            <?php endif; ?>

            <div class="opcin col-12">
                    <div class="about-icon col-12 col-md-6">
                        <?php if( have_rows('about-icon',get_option('page_on_front')) ): ?>
                        <?php while( have_rows('about-icon',get_option('page_on_front')) ): the_row(); ?>

                            <div class="about-box col-12">
                                <i><img src="<?php the_sub_field('img'); ?>" alt=""></i>
                                <h4><?php the_sub_field('name'); ?></h4>
                            </div>

                        <?php endwhile; ?>
                        <?php endif; ?>
                    </div>

            <a  href="tel:<?php the_field('tel', 'option') ?>">
                <span>اتصل بنا الآن</span>
                <?php the_field('tel', 'option') ?>
            </a>
            </div>
        </div>

        <div class="block col-12 col-md-6">
            <?php the_field('text'); ?>
            <img src="<?php the_field('img2'); ?>" alt="">
        </div>
    </div>
</section>








<section class="say">
<section class="e7sa">
    <div class="container">
            <?php the_field('e7sa-tit',get_option('page_on_front')); ?>
        <div class="blocks col-12 col-md-11">
        <?php if( have_rows('e7sa',get_option('page_on_front')) ): ?>
        <?php while( have_rows('e7sa',get_option('page_on_front')) ): the_row(); ?>

                <div class="e7sa-box col-6 col-md-3">
                    <div class="box">
                        <img src="<?php the_sub_field('img'); ?>" alt="">
                        <h4><?php the_sub_field('name'); ?></h4>
                        <p><?php the_sub_field('text'); ?></p>
                    </div>
                </div>

        <?php endwhile; ?>
        <?php endif; ?>

        </div>
    </div>
</section>
</section>      
<style>
    .say{
        padding-top: 20px;
    }
</style>








<section class="how">
    <div class="container">
        <h1><?php the_field('how-tit',get_option('page_on_front')); ?></h1>
        <h1><?php the_field('how-tit',get_option('page_on_front')); ?></h1>
        <h1><?php the_field('how-tit',get_option('page_on_front')); ?></h1>


<div class="blockall col-12">
        <div class="block col-12 col-md-3">

            <?php if( have_rows('how',get_option('page_on_front')) ): ?>
                <?php 
                $count = 0; // عداد لعدد العناصر المعروضة
                while( have_rows('how',get_option('page_on_front')) ): the_row(); 
                    $count++;
                ?>
                    <div class="box col-12">
                        <i></i>
                        <p><?php the_sub_field('text'); ?></p>
                    </div>
                <?php 
                    if( $count >= 2 ) break; // إيقاف الحلقة بعد عرض عنصرين
                endwhile; 
                ?>
            <?php endif; ?>


        </div>
        <div class="block block-center col-12 col-md-6">
            <span class="span1" ><img src="<?php bloginfo('template_directory'); ?>/img/ll.svg" alt=""></span>
            <img src="<?php the_field('how-img',get_option('page_on_front')); ?>" alt="">
            <span  class="span2"><img src="<?php bloginfo('template_directory'); ?>/img/rr.svg" alt=""></span>
        </div>
        <div class="block col-12 col-md-3">

        <?php 
if( have_rows('how',get_option('page_on_front')) ):
    $rows = []; // مصفوفة لتخزين كل العناصر
    while( have_rows('how',get_option('page_on_front')) ): the_row();
        $rows[] = [
            'name' => get_sub_field('name'),
            'text' => get_sub_field('text')
        ];
    endwhile;

    // احصل على آخر عنصرين
    $last_two = array_slice($rows, -2);

    foreach( $last_two as $row ): ?>
        <div class="box col-12">
            <i></i>
            <p><?php echo esc_html($row['text']); ?></p>
        </div>
    <?php endforeach; 
endif;
?>


        </div>

  </div>  

    </div>
</section>

<script>
  const container = document.querySelector('.block-center');

  const span1 = document.querySelector('.span1');
  const span2 = document.querySelector('.span2');
  const span11 = document.querySelector('.span11');
  const span22 = document.querySelector('.span22');

  const containerWidth = container.clientWidth;
  const containerHeight = container.clientHeight;

  // دالة لتحريك عنصر معين
  function moveRandom(el) {
    const boxWidth = el.clientWidth;
    const boxHeight = el.clientHeight;
    const x = Math.random() * (containerWidth - boxWidth);
    const y = Math.random() * (containerHeight - boxHeight);
    el.style.left = `${x}px`;
    el.style.top = `${y}px`;
  }

  // تحريك كل عنصر بتوقيت مختلف
  setInterval(() => moveRandom(span1), 2000);
  setInterval(() => moveRandom(span2), 2500);
  setInterval(() => moveRandom(span11), 1800);
  setInterval(() => moveRandom(span22), 2200);

  // حركة أول مرة
  moveRandom(span1);
  moveRandom(span2);
  moveRandom(span11);
  moveRandom(span22);
</script>






<section class="company">
    <div class="container">
        <div class="tt col"><?php the_field('comp-tit',get_option('page_on_front')); ?></div>
        <div class="comp-slider col-12">

                <?php if( have_rows('comp',get_option('page_on_front')) ): ?>
                <?php while( have_rows('comp',get_option('page_on_front')) ): the_row(); ?>
                    <div class="photo">
                        <img src="<?php the_sub_field('img'); ?>" alt="">
                    </div>
                <?php endwhile; ?>
                <?php endif; ?>


        </div>
    </div>
</section>










<?php get_footer() ?>